%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

% Parallel-plate capacitor with N dielectric sectors.
% This program calculates breakdown voltage in parallel plate capacitor
% with arbitrary number of dielectric sectors normal to the capacitor
% plates. 

clear all;
close all;

% Number of dielectric sectors
N = input('Enter the number of dielectric sectors normal to capacitor plates: ');

% Dielectric strength for each dielectric sector
for i = 1:N
    Ecr(i) = input(['Enter dielectric strength (in MV/m) for ',int2str(i),'. sector: ']);
    Ecr(i) = Ecr(i)*10^6;
end;
% The plate separation
d = input('Enter the plate separation (in mm) of the capacitor: ');
d = d/1000;

% Maximum of electric field intensity vector in each sector - before breakdown
[Emin,index] = min(Ecr);
fprintf(['Breakdown occurs in ',int2str(index),'. dielectric sector']);
% Breakdown voltage
Vcr = Emin*d;
fprintf('Breakdown voltage is: %f V.\n',Vcr);